;
;								EJEMPLO 2
;						Autor: Mikel Etxebarria
;			(c) Ingeniera de Microsistemas Programados S.L.
;						www.microcontroladores.com
;								Bilbao 2006
;
;
;Control de los leds conectados a RB0 y RB1 desde el interruptor RA0. 
;RB0 refleja el estado de RA0, RB1 el complemento de RA0
		
		List	p=16F876A		;Tipo de procesador
		include	"P16F876A.INC"	;Definiciones de registros internos

;Ajusta los valores de la palabra de configuracin durante el ensamblaje:
;Proteccin de cdigo y datos=OFF, LVP=OFF, WDT=OFF y OSC=XT

		__config _CP_OFF&_CPD_OFF&_LVP_OFF&_WDT_OFF&_XT_OSC

;Estos y otros valores se pueden modificar segn las necesidades

			org		0x00
			goto	Inicio		;Vector de reset
			org		0x05

Inicio		clrf 	PORTB		;Borra los latch de salida
			bsf		STATUS,RP0	;Selecciona banco 1
			clrf	TRISB		;Puerta B se configura como salida
			movlw	0x06
			movwf	ADCON1		;Puerta A entrada digital
			movlw	b'00011111'		
			movwf	TRISA		;Puerta A se configura como entrada
			bcf		STATUS,RP0	;Selecciona banco 0

Loop		btfsc	PORTA,0		;RA0 = 1 ??
			goto	RA0_es_1	;Si
			bcf		PORTB,0		;No, desconecta RB0
			bsf		PORTB,1		;Conecta RB1
			goto	Loop		;Buble sin fin

RA0_es_1	bsf		PORTB,0		;Activa RB0
			bcf		PORTB,1		;Activa RB1
			goto	Loop		;Bucle sin fin

			end			;Fin del programa fuente
